% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_fun.R
\name{multiple_groups}
\alias{multiple_groups}
\title{multiple_groups}
\usage{
multiple_groups(inpt_v = c(), group_size = 2)
}
\arguments{
\item{inpt_v}{is the input vector}

\item{group_size}{is the group size}
}
\description{
Output all the possible combinations between elements within a vector for a group size, see examples
}
\examples{

print(multiple_groups(inpt_v = c("Marc", "Sylvie", "Julien", "Christine", "Axel"), group_size = 2))

 [1] "Marc-Sylvie"      "Marc-Julien"      "Marc-Christine"   "Marc-Axel"       
 [5] "Sylvie-Julien"    "Sylvie-Christine" "Sylvie-Axel"      "Julien-Christine"
 [9] "Julien-Axel"      "Christine-Axel"  

print(multiple_groups(inpt_v = c("Marc", "Sylvie", "Julien", "Christine", "Axel"), group_size = 3))

 [1] "Marc-Sylvie-Julien"      "Marc-Sylvie-Christine"  
 [3] "Marc-Sylvie-Axel"        "Marc-Julien-Christine"  
 [5] "Marc-Julien-Axel"        "Marc-Christine-Axel"    
 [7] "Sylvie-Julien-Christine" "Sylvie-Julien-Axel"     
 [9] "Sylvie-Christine-Axel"   "Julien-Christine-Axel"  

print(multiple_groups(inpt_v = c("Marc", "Sylvie", "Julien", "Christine", "Axel"), group_size = 4))

[1] "Marc-Sylvie-Julien-Christine" "Marc-Sylvie-Julien-Axel"     
[3] "Marc-Sylvie-Christine-Axel"   "Marc-Julien-Christine-Axel"  
[5] "Sylvie-Julien-Christine-Axel"

print(multiple_groups(inpt_v = c("Marc", "Sylvie", "Julien", "Christine", "Axel"), group_size = 5))

[1] "Marc-Sylvie-Julien-Christine-Axel"

}
