% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_fun.R
\name{lm_label_generation2}
\alias{lm_label_generation2}
\title{lm_label_generation2}
\usage{
lm_label_generation2(inpt_datf, col_vars = c(), label_var, min_hmn, neighbrs)
}
\arguments{
\item{inpt_datf}{is the input dataframe}

\item{col_vars}{is a vector containing the column names or number of the variables}

\item{label_var}{is the column name or number of the label variable}

\item{min_hmn}{is the value from which a label is considered to appear enough times, so all individuals that have a label whose occurence is inferior will be cloned base on the method elaborated in the description of the function}

\item{neighbrs}{is how many neighbours will be taken in count to calculate the local standard deviation}
}
\description{
Same as lm_label_generation but limits the new individuals to min_hmn.
}
\examples{

datf <- iris
datf <- datf[-c(101:137),]
datf[, 5] <- as.character(datf[, 5])
datf[datf[, 5] == "setosa", 5] <- 1
datf[datf[, 5] == "versicolor", 5] <- 2
datf[datf[, 5] == "virginica", 5] <- 3
datf[, 5] <- as.numeric(datf[, 5])
rownames(datf) <- c(1:nrow(datf))
print(datf)

    Sepal.Length Sepal.Width Petal.Length Petal.Width Species
1            5.1         3.5          1.4         0.2       1
2            4.9         3.0          1.4         0.2       1
3            4.7         3.2          1.3         0.2       1
4            4.6         3.1          1.5         0.2       1
5            5.0         3.6          1.4         0.2       1
6            5.4         3.9          1.7         0.4       1
7            4.6         3.4          1.4         0.3       1
8            5.0         3.4          1.5         0.2       1
9            4.4         2.9          1.4         0.2       1
10           4.9         3.1          1.5         0.1       1
11           5.4         3.7          1.5         0.2       1
12           4.8         3.4          1.6         0.2       1
13           4.8         3.0          1.4         0.1       1
14           4.3         3.0          1.1         0.1       1
15           5.8         4.0          1.2         0.2       1
16           5.7         4.4          1.5         0.4       1
17           5.4         3.9          1.3         0.4       1
18           5.1         3.5          1.4         0.3       1
19           5.7         3.8          1.7         0.3       1
20           5.1         3.8          1.5         0.3       1
21           5.4         3.4          1.7         0.2       1
22           5.1         3.7          1.5         0.4       1
23           4.6         3.6          1.0         0.2       1
24           5.1         3.3          1.7         0.5       1
25           4.8         3.4          1.9         0.2       1
26           5.0         3.0          1.6         0.2       1
27           5.0         3.4          1.6         0.4       1
28           5.2         3.5          1.5         0.2       1
29           5.2         3.4          1.4         0.2       1
30           4.7         3.2          1.6         0.2       1
31           4.8         3.1          1.6         0.2       1
32           5.4         3.4          1.5         0.4       1
33           5.2         4.1          1.5         0.1       1
34           5.5         4.2          1.4         0.2       1
35           4.9         3.1          1.5         0.2       1
36           5.0         3.2          1.2         0.2       1
37           5.5         3.5          1.3         0.2       1
38           4.9         3.6          1.4         0.1       1
39           4.4         3.0          1.3         0.2       1
40           5.1         3.4          1.5         0.2       1
41           5.0         3.5          1.3         0.3       1
42           4.5         2.3          1.3         0.3       1
43           4.4         3.2          1.3         0.2       1
44           5.0         3.5          1.6         0.6       1
45           5.1         3.8          1.9         0.4       1
46           4.8         3.0          1.4         0.3       1
47           5.1         3.8          1.6         0.2       1
48           4.6         3.2          1.4         0.2       1
49           5.3         3.7          1.5         0.2       1
50           5.0         3.3          1.4         0.2       1
51           7.0         3.2          4.7         1.4       2
52           6.4         3.2          4.5         1.5       2
53           6.9         3.1          4.9         1.5       2
54           5.5         2.3          4.0         1.3       2
55           6.5         2.8          4.6         1.5       2
56           5.7         2.8          4.5         1.3       2
57           6.3         3.3          4.7         1.6       2
58           4.9         2.4          3.3         1.0       2
59           6.6         2.9          4.6         1.3       2
60           5.2         2.7          3.9         1.4       2
61           5.0         2.0          3.5         1.0       2
62           5.9         3.0          4.2         1.5       2
63           6.0         2.2          4.0         1.0       2
64           6.1         2.9          4.7         1.4       2
65           5.6         2.9          3.6         1.3       2
66           6.7         3.1          4.4         1.4       2
67           5.6         3.0          4.5         1.5       2
68           5.8         2.7          4.1         1.0       2
69           6.2         2.2          4.5         1.5       2
70           5.6         2.5          3.9         1.1       2
71           5.9         3.2          4.8         1.8       2
72           6.1         2.8          4.0         1.3       2
73           6.3         2.5          4.9         1.5       2
74           6.1         2.8          4.7         1.2       2
75           6.4         2.9          4.3         1.3       2
76           6.6         3.0          4.4         1.4       2
77           6.8         2.8          4.8         1.4       2
78           6.7         3.0          5.0         1.7       2
79           6.0         2.9          4.5         1.5       2
80           5.7         2.6          3.5         1.0       2
81           5.5         2.4          3.8         1.1       2
82           5.5         2.4          3.7         1.0       2
83           5.8         2.7          3.9         1.2       2
84           6.0         2.7          5.1         1.6       2
85           5.4         3.0          4.5         1.5       2
86           6.0         3.4          4.5         1.6       2
87           6.7         3.1          4.7         1.5       2
88           6.3         2.3          4.4         1.3       2
89           5.6         3.0          4.1         1.3       2
90           5.5         2.5          4.0         1.3       2
91           5.5         2.6          4.4         1.2       2
92           6.1         3.0          4.6         1.4       2
93           5.8         2.6          4.0         1.2       2
94           5.0         2.3          3.3         1.0       2
95           5.6         2.7          4.2         1.3       2
96           5.7         3.0          4.2         1.2       2
97           5.7         2.9          4.2         1.3       2
98           6.2         2.9          4.3         1.3       2
99           5.1         2.5          3.0         1.1       2
100          5.7         2.8          4.1         1.3       2
101          6.4         3.1          5.5         1.8       3
102          6.0         3.0          4.8         1.8       3
103          6.9         3.1          5.4         2.1       3
104          6.7         3.1          5.6         2.4       3
105          6.9         3.1          5.1         2.3       3
106          5.8         2.7          5.1         1.9       3
107          6.8         3.2          5.9         2.3       3
108          6.7         3.3          5.7         2.5       3
109          6.7         3.0          5.2         2.3       3
110          6.3         2.5          5.0         1.9       3
111          6.5         3.0          5.2         2.0       3
112          6.2         3.4          5.4         2.3       3
113          5.9         3.0          5.1         1.8       3

print(lm_label_generation2(
                          inpt_datf = datf,
                          col_vars = c(1:4),
                          label_var = 5,
                          min_hmn = 50,
                          neighbrs = 3
                          )
)

    Sepal.Length Sepal.Width Petal.Length Petal.Width Species
1       5.100000    3.500000     1.400000    0.200000       1
2       4.900000    3.000000     1.400000    0.200000       1
3       4.700000    3.200000     1.300000    0.200000       1
4       4.600000    3.100000     1.500000    0.200000       1
5       5.000000    3.600000     1.400000    0.200000       1
6       5.400000    3.900000     1.700000    0.400000       1
7       4.600000    3.400000     1.400000    0.300000       1
8       5.000000    3.400000     1.500000    0.200000       1
9       4.400000    2.900000     1.400000    0.200000       1
10      4.900000    3.100000     1.500000    0.100000       1
11      5.400000    3.700000     1.500000    0.200000       1
12      4.800000    3.400000     1.600000    0.200000       1
13      4.800000    3.000000     1.400000    0.100000       1
14      4.300000    3.000000     1.100000    0.100000       1
15      5.800000    4.000000     1.200000    0.200000       1
16      5.700000    4.400000     1.500000    0.400000       1
17      5.400000    3.900000     1.300000    0.400000       1
18      5.100000    3.500000     1.400000    0.300000       1
19      5.700000    3.800000     1.700000    0.300000       1
20      5.100000    3.800000     1.500000    0.300000       1
21      5.400000    3.400000     1.700000    0.200000       1
22      5.100000    3.700000     1.500000    0.400000       1
23      4.600000    3.600000     1.000000    0.200000       1
24      5.100000    3.300000     1.700000    0.500000       1
25      4.800000    3.400000     1.900000    0.200000       1
26      5.000000    3.000000     1.600000    0.200000       1
27      5.000000    3.400000     1.600000    0.400000       1
28      5.200000    3.500000     1.500000    0.200000       1
29      5.200000    3.400000     1.400000    0.200000       1
30      4.700000    3.200000     1.600000    0.200000       1
31      4.800000    3.100000     1.600000    0.200000       1
32      5.400000    3.400000     1.500000    0.400000       1
33      5.200000    4.100000     1.500000    0.100000       1
34      5.500000    4.200000     1.400000    0.200000       1
35      4.900000    3.100000     1.500000    0.200000       1
36      5.000000    3.200000     1.200000    0.200000       1
37      5.500000    3.500000     1.300000    0.200000       1
38      4.900000    3.600000     1.400000    0.100000       1
39      4.400000    3.000000     1.300000    0.200000       1
40      5.100000    3.400000     1.500000    0.200000       1
41      5.000000    3.500000     1.300000    0.300000       1
42      4.500000    2.300000     1.300000    0.300000       1
43      4.400000    3.200000     1.300000    0.200000       1
44      5.000000    3.500000     1.600000    0.600000       1
45      5.100000    3.800000     1.900000    0.400000       1
46      4.800000    3.000000     1.400000    0.300000       1
47      5.100000    3.800000     1.600000    0.200000       1
48      4.600000    3.200000     1.400000    0.200000       1
49      5.300000    3.700000     1.500000    0.200000       1
50      5.000000    3.300000     1.400000    0.200000       1
51      7.000000    3.200000     4.700000    1.400000       2
52      6.400000    3.200000     4.500000    1.500000       2
53      6.900000    3.100000     4.900000    1.500000       2
54      5.500000    2.300000     4.000000    1.300000       2
55      6.500000    2.800000     4.600000    1.500000       2
56      5.700000    2.800000     4.500000    1.300000       2
57      6.300000    3.300000     4.700000    1.600000       2
58      4.900000    2.400000     3.300000    1.000000       2
59      6.600000    2.900000     4.600000    1.300000       2
60      5.200000    2.700000     3.900000    1.400000       2
61      5.000000    2.000000     3.500000    1.000000       2
62      5.900000    3.000000     4.200000    1.500000       2
63      6.000000    2.200000     4.000000    1.000000       2
64      6.100000    2.900000     4.700000    1.400000       2
65      5.600000    2.900000     3.600000    1.300000       2
66      6.700000    3.100000     4.400000    1.400000       2
67      5.600000    3.000000     4.500000    1.500000       2
68      5.800000    2.700000     4.100000    1.000000       2
69      6.200000    2.200000     4.500000    1.500000       2
70      5.600000    2.500000     3.900000    1.100000       2
71      5.900000    3.200000     4.800000    1.800000       2
72      6.100000    2.800000     4.000000    1.300000       2
73      6.300000    2.500000     4.900000    1.500000       2
74      6.100000    2.800000     4.700000    1.200000       2
75      6.400000    2.900000     4.300000    1.300000       2
76      6.600000    3.000000     4.400000    1.400000       2
77      6.800000    2.800000     4.800000    1.400000       2
78      6.700000    3.000000     5.000000    1.700000       2
79      6.000000    2.900000     4.500000    1.500000       2
80      5.700000    2.600000     3.500000    1.000000       2
81      5.500000    2.400000     3.800000    1.100000       2
82      5.500000    2.400000     3.700000    1.000000       2
83      5.800000    2.700000     3.900000    1.200000       2
84      6.000000    2.700000     5.100000    1.600000       2
85      5.400000    3.000000     4.500000    1.500000       2
86      6.000000    3.400000     4.500000    1.600000       2
87      6.700000    3.100000     4.700000    1.500000       2
88      6.300000    2.300000     4.400000    1.300000       2
89      5.600000    3.000000     4.100000    1.300000       2
90      5.500000    2.500000     4.000000    1.300000       2
91      5.500000    2.600000     4.400000    1.200000       2
92      6.100000    3.000000     4.600000    1.400000       2
93      5.800000    2.600000     4.000000    1.200000       2
94      5.000000    2.300000     3.300000    1.000000       2
95      5.600000    2.700000     4.200000    1.300000       2
96      5.700000    3.000000     4.200000    1.200000       2
97      5.700000    2.900000     4.200000    1.300000       2
98      6.200000    2.900000     4.300000    1.300000       2
99      5.100000    2.500000     3.000000    1.100000       2
100     5.700000    2.800000     4.100000    1.300000       2
101     6.400000    3.100000     5.500000    1.800000       3
102     6.000000    3.000000     4.800000    1.800000       3
103     6.900000    3.100000     5.400000    2.100000       3
104     6.700000    3.100000     5.600000    2.400000       3
105     6.900000    3.100000     5.100000    2.300000       3
106     5.800000    2.700000     5.100000    1.900000       3
107     6.800000    3.200000     5.900000    2.300000       3
108     6.700000    3.300000     5.700000    2.500000       3
109     6.700000    3.000000     5.200000    2.300000       3
110     6.300000    2.500000     5.000000    1.900000       3
111     6.500000    3.000000     5.200000    2.000000       3
112     6.200000    3.400000     5.400000    2.300000       3
113     5.900000    3.000000     5.100000    1.800000       3
114     3.262233   -2.836161     1.209831    3.756150       3
115     2.792928   -2.598126     1.903514    4.021822       3
116     2.660366   -3.253078     1.773561    3.552828       3
117     3.212474   -2.968186     1.299036    4.002004       3
118     3.304691   -3.120160     1.776056    3.421424       3
119     3.129013   -2.764565     1.084363    3.961070       3
120     3.278919   -2.962809     1.872274    3.862973       3
121     2.555308   -2.875592     1.808080    3.195783       3
122     3.466773   -3.325957     1.601554    3.675986       3
123     2.574830   -2.761658     1.151314    3.923658       3
124     3.324925   -3.055837     1.639577    3.913790       3
125     2.984227   -2.962149     1.721951    3.726171       3
126     3.149486   -2.664939     1.988111    4.036337       3
127     3.239279   -2.812136     1.961199    3.589471       3
128     3.124868   -2.825058     1.185327    3.550925       3
129     2.818810   -2.812702     1.497583    3.940851       3
130     2.947275   -3.162957     1.582021    3.577329       3
131     3.484623   -3.069765     1.952411    4.085512       3
132     2.461561   -2.772750     1.406235    3.823907       3
133     2.845755   -3.061859     2.278193    3.937838       3
134     3.382535   -3.103582     1.736065    4.025574       3
135     3.233128   -3.386703     1.333698    4.273769       3
136     3.189359   -2.823622     1.296134    4.140628       3
137     3.091862   -2.863102     1.080645    3.964312       3
138     2.741842   -2.929970     1.889022    3.713229       3
139     2.578026   -2.971548     1.597677    3.932410       3
140     2.925473   -3.323804     1.177113    3.551214       3
141     3.029594   -3.006599     1.350195    3.984042       3
142     2.755172   -2.698046     1.949463    3.811956       3
143     2.894695   -3.184067     1.605452    3.474205       3
144     3.260417   -2.908241     1.578760    3.691196       3
145     3.006636   -3.034710     1.628828    3.369206       3
146     3.352774   -2.915606     1.327263    3.699141       3
147     2.760372   -3.282009     1.762860    3.890322       3
148     3.545501   -3.080867     2.008176    3.930908       3
149     2.916121   -2.846311     1.822271    3.971336       3
150     2.827684   -3.028701     2.221580    3.957002       3

}
