% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_fun.R
\name{lm_label_generation}
\alias{lm_label_generation}
\title{lm_label_generation}
\usage{
lm_label_generation(inpt_datf, col_vars = c(), label_var, min_hmn, neighbrs)
}
\arguments{
\item{inpt_datf}{is the input dataframe}

\item{col_vars}{is a vector containing the column names or number of the variables}

\item{label_var}{is the column name or number of the label variable}

\item{min_hmn}{is the value from which a label is considered to appear enough times, so all individuals that have a label whose occurence is inferior will be cloned base on the method elaborated in the description of the function}

\item{neighbrs}{is how many neighbours will be taken in count to calculate the local standard deviation}
}
\description{
Allow to generate new individuals whose label are not present enough. It supposes that the variables and the label al have a linear relationship. This methods generates values of variables for new individuals based on a normal distribution whose mean is the value of the function found after a linear regression between a variable and the label, at the x value (label value). The standard deviation associated with the normal distribution is the local standard deviation with a given amount of neighbours. A neighbour is the set of individuals that share the same label. If the amount of neighbours exceeds the number of labels, so all labels will be considerd as a neighboor to calculate the local standard deviation.
}
\examples{

datf <- iris
datf <- datf[-c(101:137),]
datf[, 5] <- as.character(datf[, 5])
datf[datf[, 5] == "setosa", 5] <- 1
datf[datf[, 5] == "versicolor", 5] <- 2
datf[datf[, 5] == "virginica", 5] <- 3
datf[, 5] <- as.numeric(datf[, 5])
rownames(datf) <- c(1:nrow(datf))
print(datf)

    Sepal.Length Sepal.Width Petal.Length Petal.Width Species
1            5.1         3.5          1.4         0.2       1
2            4.9         3.0          1.4         0.2       1
3            4.7         3.2          1.3         0.2       1
4            4.6         3.1          1.5         0.2       1
5            5.0         3.6          1.4         0.2       1
6            5.4         3.9          1.7         0.4       1
7            4.6         3.4          1.4         0.3       1
8            5.0         3.4          1.5         0.2       1
9            4.4         2.9          1.4         0.2       1
10           4.9         3.1          1.5         0.1       1
11           5.4         3.7          1.5         0.2       1
12           4.8         3.4          1.6         0.2       1
13           4.8         3.0          1.4         0.1       1
14           4.3         3.0          1.1         0.1       1
15           5.8         4.0          1.2         0.2       1
16           5.7         4.4          1.5         0.4       1
17           5.4         3.9          1.3         0.4       1
18           5.1         3.5          1.4         0.3       1
19           5.7         3.8          1.7         0.3       1
20           5.1         3.8          1.5         0.3       1
21           5.4         3.4          1.7         0.2       1
22           5.1         3.7          1.5         0.4       1
23           4.6         3.6          1.0         0.2       1
24           5.1         3.3          1.7         0.5       1
25           4.8         3.4          1.9         0.2       1
26           5.0         3.0          1.6         0.2       1
27           5.0         3.4          1.6         0.4       1
28           5.2         3.5          1.5         0.2       1
29           5.2         3.4          1.4         0.2       1
30           4.7         3.2          1.6         0.2       1
31           4.8         3.1          1.6         0.2       1
32           5.4         3.4          1.5         0.4       1
33           5.2         4.1          1.5         0.1       1
34           5.5         4.2          1.4         0.2       1
35           4.9         3.1          1.5         0.2       1
36           5.0         3.2          1.2         0.2       1
37           5.5         3.5          1.3         0.2       1
38           4.9         3.6          1.4         0.1       1
39           4.4         3.0          1.3         0.2       1
40           5.1         3.4          1.5         0.2       1
41           5.0         3.5          1.3         0.3       1
42           4.5         2.3          1.3         0.3       1
43           4.4         3.2          1.3         0.2       1
44           5.0         3.5          1.6         0.6       1
45           5.1         3.8          1.9         0.4       1
46           4.8         3.0          1.4         0.3       1
47           5.1         3.8          1.6         0.2       1
48           4.6         3.2          1.4         0.2       1
49           5.3         3.7          1.5         0.2       1
50           5.0         3.3          1.4         0.2       1
51           7.0         3.2          4.7         1.4       2
52           6.4         3.2          4.5         1.5       2
53           6.9         3.1          4.9         1.5       2
54           5.5         2.3          4.0         1.3       2
55           6.5         2.8          4.6         1.5       2
56           5.7         2.8          4.5         1.3       2
57           6.3         3.3          4.7         1.6       2
58           4.9         2.4          3.3         1.0       2
59           6.6         2.9          4.6         1.3       2
60           5.2         2.7          3.9         1.4       2
61           5.0         2.0          3.5         1.0       2
62           5.9         3.0          4.2         1.5       2
63           6.0         2.2          4.0         1.0       2
64           6.1         2.9          4.7         1.4       2
65           5.6         2.9          3.6         1.3       2
66           6.7         3.1          4.4         1.4       2
67           5.6         3.0          4.5         1.5       2
68           5.8         2.7          4.1         1.0       2
69           6.2         2.2          4.5         1.5       2
70           5.6         2.5          3.9         1.1       2
71           5.9         3.2          4.8         1.8       2
72           6.1         2.8          4.0         1.3       2
73           6.3         2.5          4.9         1.5       2
74           6.1         2.8          4.7         1.2       2
75           6.4         2.9          4.3         1.3       2
76           6.6         3.0          4.4         1.4       2
77           6.8         2.8          4.8         1.4       2
78           6.7         3.0          5.0         1.7       2
79           6.0         2.9          4.5         1.5       2
80           5.7         2.6          3.5         1.0       2
81           5.5         2.4          3.8         1.1       2
82           5.5         2.4          3.7         1.0       2
83           5.8         2.7          3.9         1.2       2
84           6.0         2.7          5.1         1.6       2
85           5.4         3.0          4.5         1.5       2
86           6.0         3.4          4.5         1.6       2
87           6.7         3.1          4.7         1.5       2
88           6.3         2.3          4.4         1.3       2
89           5.6         3.0          4.1         1.3       2
90           5.5         2.5          4.0         1.3       2
91           5.5         2.6          4.4         1.2       2
92           6.1         3.0          4.6         1.4       2
93           5.8         2.6          4.0         1.2       2
94           5.0         2.3          3.3         1.0       2
95           5.6         2.7          4.2         1.3       2
96           5.7         3.0          4.2         1.2       2
97           5.7         2.9          4.2         1.3       2
98           6.2         2.9          4.3         1.3       2
99           5.1         2.5          3.0         1.1       2
100          5.7         2.8          4.1         1.3       2
101          6.4         3.1          5.5         1.8       3
102          6.0         3.0          4.8         1.8       3
103          6.9         3.1          5.4         2.1       3
104          6.7         3.1          5.6         2.4       3
105          6.9         3.1          5.1         2.3       3
106          5.8         2.7          5.1         1.9       3
107          6.8         3.2          5.9         2.3       3
108          6.7         3.3          5.7         2.5       3
109          6.7         3.0          5.2         2.3       3
110          6.3         2.5          5.0         1.9       3
111          6.5         3.0          5.2         2.0       3
112          6.2         3.4          5.4         2.3       3
113          5.9         3.0          5.1         1.8       3

print(lm_label_generation(
                          inpt_datf = datf,
                          col_vars = c(1:4),
                          label_var = 5,
                          min_hmn = 50,
                          neighbrs = 3
                          )
)

    Sepal.Length Sepal.Width Petal.Length Petal.Width Species
1       5.100000    3.500000    1.4000000    0.200000       1
2       4.900000    3.000000    1.4000000    0.200000       1
3       4.700000    3.200000    1.3000000    0.200000       1
4       4.600000    3.100000    1.5000000    0.200000       1
5       5.000000    3.600000    1.4000000    0.200000       1
6       5.400000    3.900000    1.7000000    0.400000       1
7       4.600000    3.400000    1.4000000    0.300000       1
8       5.000000    3.400000    1.5000000    0.200000       1
9       4.400000    2.900000    1.4000000    0.200000       1
10      4.900000    3.100000    1.5000000    0.100000       1
11      5.400000    3.700000    1.5000000    0.200000       1
12      4.800000    3.400000    1.6000000    0.200000       1
13      4.800000    3.000000    1.4000000    0.100000       1
14      4.300000    3.000000    1.1000000    0.100000       1
15      5.800000    4.000000    1.2000000    0.200000       1
16      5.700000    4.400000    1.5000000    0.400000       1
17      5.400000    3.900000    1.3000000    0.400000       1
18      5.100000    3.500000    1.4000000    0.300000       1
19      5.700000    3.800000    1.7000000    0.300000       1
20      5.100000    3.800000    1.5000000    0.300000       1
21      5.400000    3.400000    1.7000000    0.200000       1
22      5.100000    3.700000    1.5000000    0.400000       1
23      4.600000    3.600000    1.0000000    0.200000       1
24      5.100000    3.300000    1.7000000    0.500000       1
25      4.800000    3.400000    1.9000000    0.200000       1
26      5.000000    3.000000    1.6000000    0.200000       1
27      5.000000    3.400000    1.6000000    0.400000       1
28      5.200000    3.500000    1.5000000    0.200000       1
29      5.200000    3.400000    1.4000000    0.200000       1
30      4.700000    3.200000    1.6000000    0.200000       1
31      4.800000    3.100000    1.6000000    0.200000       1
32      5.400000    3.400000    1.5000000    0.400000       1
33      5.200000    4.100000    1.5000000    0.100000       1
34      5.500000    4.200000    1.4000000    0.200000       1
35      4.900000    3.100000    1.5000000    0.200000       1
36      5.000000    3.200000    1.2000000    0.200000       1
37      5.500000    3.500000    1.3000000    0.200000       1
38      4.900000    3.600000    1.4000000    0.100000       1
39      4.400000    3.000000    1.3000000    0.200000       1
40      5.100000    3.400000    1.5000000    0.200000       1
41      5.000000    3.500000    1.3000000    0.300000       1
42      4.500000    2.300000    1.3000000    0.300000       1
43      4.400000    3.200000    1.3000000    0.200000       1
44      5.000000    3.500000    1.6000000    0.600000       1
45      5.100000    3.800000    1.9000000    0.400000       1
46      4.800000    3.000000    1.4000000    0.300000       1
47      5.100000    3.800000    1.6000000    0.200000       1
48      4.600000    3.200000    1.4000000    0.200000       1
49      5.300000    3.700000    1.5000000    0.200000       1
50      5.000000    3.300000    1.4000000    0.200000       1
51      7.000000    3.200000    4.7000000    1.400000       2
52      6.400000    3.200000    4.5000000    1.500000       2
53      6.900000    3.100000    4.9000000    1.500000       2
54      5.500000    2.300000    4.0000000    1.300000       2
55      6.500000    2.800000    4.6000000    1.500000       2
56      5.700000    2.800000    4.5000000    1.300000       2
57      6.300000    3.300000    4.7000000    1.600000       2
58      4.900000    2.400000    3.3000000    1.000000       2
59      6.600000    2.900000    4.6000000    1.300000       2
60      5.200000    2.700000    3.9000000    1.400000       2
61      5.000000    2.000000    3.5000000    1.000000       2
62      5.900000    3.000000    4.2000000    1.500000       2
63      6.000000    2.200000    4.0000000    1.000000       2
64      6.100000    2.900000    4.7000000    1.400000       2
65      5.600000    2.900000    3.6000000    1.300000       2
66      6.700000    3.100000    4.4000000    1.400000       2
67      5.600000    3.000000    4.5000000    1.500000       2
68      5.800000    2.700000    4.1000000    1.000000       2
69      6.200000    2.200000    4.5000000    1.500000       2
70      5.600000    2.500000    3.9000000    1.100000       2
71      5.900000    3.200000    4.8000000    1.800000       2
72      6.100000    2.800000    4.0000000    1.300000       2
73      6.300000    2.500000    4.9000000    1.500000       2
74      6.100000    2.800000    4.7000000    1.200000       2
75      6.400000    2.900000    4.3000000    1.300000       2
76      6.600000    3.000000    4.4000000    1.400000       2
77      6.800000    2.800000    4.8000000    1.400000       2
78      6.700000    3.000000    5.0000000    1.700000       2
79      6.000000    2.900000    4.5000000    1.500000       2
80      5.700000    2.600000    3.5000000    1.000000       2
81      5.500000    2.400000    3.8000000    1.100000       2
82      5.500000    2.400000    3.7000000    1.000000       2
83      5.800000    2.700000    3.9000000    1.200000       2
84      6.000000    2.700000    5.1000000    1.600000       2
85      5.400000    3.000000    4.5000000    1.500000       2
86      6.000000    3.400000    4.5000000    1.600000       2
87      6.700000    3.100000    4.7000000    1.500000       2
88      6.300000    2.300000    4.4000000    1.300000       2
89      5.600000    3.000000    4.1000000    1.300000       2
90      5.500000    2.500000    4.0000000    1.300000       2
91      5.500000    2.600000    4.4000000    1.200000       2
92      6.100000    3.000000    4.6000000    1.400000       2
93      5.800000    2.600000    4.0000000    1.200000       2
94      5.000000    2.300000    3.3000000    1.000000       2
95      5.600000    2.700000    4.2000000    1.300000       2
96      5.700000    3.000000    4.2000000    1.200000       2
97      5.700000    2.900000    4.2000000    1.300000       2
98      6.200000    2.900000    4.3000000    1.300000       2
99      5.100000    2.500000    3.0000000    1.100000       2
100     5.700000    2.800000    4.1000000    1.300000       2
101     6.400000    3.100000    5.5000000    1.800000       3
102     6.000000    3.000000    4.8000000    1.800000       3
103     6.900000    3.100000    5.4000000    2.100000       3
104     6.700000    3.100000    5.6000000    2.400000       3
105     6.900000    3.100000    5.1000000    2.300000       3
106     5.800000    2.700000    5.1000000    1.900000       3
107     6.800000    3.200000    5.9000000    2.300000       3
108     6.700000    3.300000    5.7000000    2.500000       3
109     6.700000    3.000000    5.2000000    2.300000       3
110     6.300000    2.500000    5.0000000    1.900000       3
111     6.500000    3.000000    5.2000000    2.000000       3
112     6.200000    3.400000    5.4000000    2.300000       3
113     5.900000    3.000000    5.1000000    1.800000       3
114     3.337086   -3.010967    1.6118130    3.624331       3
115     2.411537   -2.886464    1.4126476    3.660604       3
116     3.210020   -2.775710    1.5750895    4.172761       3
117     2.929791   -3.155015    1.4007481    3.564110       3
118     3.308786   -3.254998    1.9936545    3.504558       3
119     3.289197   -2.825299    1.4533275    3.560123       3
120     3.182515   -3.192980    1.5196816    3.555298       3
121     3.559725   -3.018141    1.8414595    3.752408       3
122     2.611399   -2.798353    1.7837746    4.255737       3
123     3.031710   -2.905473    1.3845924    3.425221       3
124     2.905517   -2.759015    1.4464214    3.748606       3
125     2.356676   -2.929148    1.8148241    3.675484       3
126     3.186993   -2.748881    1.8868197    3.527604       3
127     3.332580   -2.814485    1.3231994    3.465241       3
128     3.029835   -3.217453    1.7912804    3.517651       3
129     3.073081   -3.306620    1.7800284    3.718459       3
130     3.283990   -3.215174    1.7407919    3.897852       3
131     3.087140   -2.990210    1.7520826    3.644679       3
132     3.272970   -3.056268    1.3994579    3.540260       3
133     2.450407   -2.841814    2.3437436    3.755238       3
134     3.545044   -3.040000    1.7329403    3.676300       3
135     2.839665   -3.111823    1.7736373    4.393735       3
136     2.875360   -3.351643    1.8670479    3.340322       3
137     2.850900   -3.282528    1.7458047    3.631666       3
138     2.492785   -3.131132    1.9228884    3.933619       3
139     2.479979   -3.049675    1.6795634    3.994376       3
140     2.382085   -2.973920    1.1220551    4.179145       3
141     2.924159   -2.872431    1.5889779    3.133596       3
142     3.431704   -3.225922    1.0053766    3.789316       3
143     2.878903   -2.750559    1.6468587    3.586866       3
144     3.053275   -3.085656    1.9171936    3.904307       3
145     2.604087   -2.627083    1.8233054    3.420803       3
146     2.601047   -2.965508    1.2239290    3.741698       3
147     3.348790   -3.394497    1.2943973    3.773516       3
148     4.017690   -3.020744    1.8265688    4.236493       3
149     2.351940   -3.299626    1.9135616    3.834306       3
150     2.927660   -2.947511    1.8911915    4.142867       3
151     2.948031   -2.898694    1.4692856    3.829044       3
152     3.244506   -3.159445    1.6976699    3.413799       3
153     2.863441   -3.034045    2.0560847    3.728603       3
154     3.348731   -3.217367    1.4792292    3.894735       3
155     3.383924   -3.285755    1.4741631    4.192404       3
156     3.110906   -3.351680    0.8286602    4.029459       3
157     3.238545   -2.820779    1.6919874    3.985022       3
158     3.468800   -2.888302    1.9049297    3.845491       3
159     3.277903   -3.219843    1.4328682    3.715557       3
160     3.178165   -3.178437    0.9839534    3.661058       3
161     3.272029   -3.334494    1.5386834    3.903441       3
162     2.950301   -2.956331    1.5906415    3.596755       3
163     3.413660   -3.506169    1.4874070    3.870051       3

}
