% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_fun.R
\name{knn_Rmach_cross_validation_train}
\alias{knn_Rmach_cross_validation_train}
\title{knn_Rmach_cross_validation_train}
\usage{
knn_Rmach_cross_validation_train(
  inpt_datf,
  train_prop_v = c(),
  k,
  n_fold = 5,
  col_vars = c(),
  class_col
)
}
\arguments{
\item{inpt_datf}{is the input dataset as a ddataframe}

\item{n_fold}{is the number of fold used for each value of k, the higher this value is, he more accurate the result will be but the higher the amount of time it will takes}

\item{col_vars}{is a vector containing the column names or numbers of the variables in the input dataframe}

\item{class_col}{is the column names or number of the variable to predict in the input dataframe}

\item{train_prop}{is the training proportion}

\item{knn_v}{is a vector containing the values of k neighbours to test}
}
\description{
Allow to perform knn with cross validation for the optimal value of k neighbours used, see examples and parameters. The result outputed is a vector containing the ratio of correct label found divided by the total number of individuals in the current dataset where the training occurred. So, higher is better.
}
\examples{

iris[, 5] <- as.character(iris[, 5])
print(knn_Rmach_cross_validation_train(
        inpt_datf = iris,
        col_vars = c(1:4),
        n_fold = 15,
        k = 7,
        class_col = 5,
        train_prop_v = c(0.7, 0.75, 0.8)
))

[1] 0.4057143 0.3273810 0.2400000

# here the optimal training proportion is 0.7

}
