% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_fun.R
\name{knn_Rmach_cross_validation_k}
\alias{knn_Rmach_cross_validation_k}
\title{knn_Rmach_cross_validation_k}
\usage{
knn_Rmach_cross_validation_k(
  inpt_datf,
  train_prop,
  knn_v = c(),
  n_fold = 5,
  col_vars = c(),
  class_col
)
}
\arguments{
\item{inpt_datf}{is the input dataset as a ddataframe}

\item{train_prop}{is the training proportion}

\item{knn_v}{is a vector containing the values of k neighbours to test}

\item{n_fold}{is the number of fold used for each value of k, the higher this value is, he more accurate the result will be but the higher the amount of time it will takes}

\item{col_vars}{is a vector containing the column names or numbers of the variables in the input dataframe}

\item{class_col}{is the column names or number of the variable to predict in the input dataframe}
}
\description{
Allow to perform knn with cross validation for the optimal value of k neighbours used, see examples and parameters. The result outputed is a vector containing the ratio of correct label found divided by the total number of unique individuals in the current dataset where the training occurred. So, higher is better.
}
\examples{

iris[, 5] <- as.character(iris[, 5])
print(knn_Rmach_cross_validation_k(
        inpt_datf = iris,
        col_vars = c(1:4),
        n_fold = 5,
        knn_v = c(3, 5, 7, 9, 11),
        class_col = 5,
        train_prop = 0.7
))

[1] 0.9333333 0.9200000 0.9333333 0.9466667 0.9288889

# here the optimal k value is 9

}
