% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_fun.R
\name{knn_Rmach}
\alias{knn_Rmach}
\title{knn_Rmach}
\usage{
knn_Rmach(train, test, k, col_vars_train = c(), col_vars_test = c(), class_col)
}
\arguments{
\item{train}{is a dataframe with the known individual and their variadbles and classification columns}

\item{test}{is a dataframe with the new individuals with ich e do not know the class, only the variables}

\item{k}{is the number of neighbours}

\item{col_vars_train}{is a vector containing the column names or column numbers of the variables in train, if empty all column are considered as a variable apart from the last one that is considered as the classification column}

\item{col_vars_test}{is a vector containing the column names or column numbers of the variables in test, if empty all column are considered as a variable}

\item{class_col}{is the column name or column number of the classification column in train}
}
\description{
KNN algorythm, see example
}
\examples{

cur_ids <- round(runif(n = 45, min = 1, max = 150))

vec <- knn_Rmach(train = iris[-cur_ids,], 
          test = iris[cur_ids, 1:4],
           col_vars_train = c(1:4),
          col_vars_test = c(1:4),
          class_col = 5,
          k = 3
       )

sum(vec == iris[cur_ids, 5]) / 45

[1] 0.9555556

}
